local assets =
{
    Asset("ANIM", "anim/fire.zip"),
    Asset("SOUND", "sound/common.fsb"),
}

local prefabs =
{
    "firefx_light",
}

local heats = { 30, 70, 120, 180, 220, 240 }

local function GetHeatFn(inst)
    return heats[inst.components.firefx.level] or 20
end

local firelevels =
{
    {anim="level1", anim_controlled_burn="level1_controlled_burn", sound="dontstarve/common/campfire", radius=2, intensity=.75, falloff=.33, colour = {197/255,197/255,170/255}, soundintensity=.1},
    {anim="level2", anim_controlled_burn="level2_controlled_burn", sound="dontstarve/common/campfire", radius=3, intensity=.8, falloff=.33, colour = {255/255,255/255,192/255}, soundintensity=.3},
    {anim="level3", anim_controlled_burn="level3_controlled_burn", sound="dontstarve/common/campfire", radius=4, intensity=.8, falloff=.33, colour = {255/255,255/255,192/255}, soundintensity=.6},
    {anim="level4", anim_controlled_burn="level4_controlled_burn", sound="dontstarve/common/campfire", radius=5, intensity=.9, falloff=.25, colour = {255/255,190/255,121/255}, soundintensity=1},
    {anim="level4", anim_controlled_burn="level4_controlled_burn", sound="dontstarve/common/forestfire", radius=6, intensity=.9, falloff=.2, colour = {255/255,190/255,121/255}, soundintensity=1},
    {anim="level5", anim_controlled_burn="level5_controlled_burn", sound="dontstarve/common/forestfire", radius=7, intensity=.9, falloff=.2, colour = {255/255,190/255,121/255}, soundintensity=1},
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    inst.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
    inst.AnimState:SetBank("fire")
    inst.AnimState:SetBuild("fire")
    inst.AnimState:SetRayTestOnBB(true)
    inst.AnimState:SetFinalOffset(FINALOFFSET_MAX)

    inst:AddTag("FX")

    --HASHEATER (from heater component) added to pristine state for optimization
    inst:AddTag("HASHEATER")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("firefx")
    inst.components.firefx.levels = firelevels

    inst.components.firefx.extinguishsoundtest = function()
        local x,y,z = inst.Transform:GetWorldPosition()
        local ents = TheSim:FindEntities(x,y,z, 5)
        local fireyness = 0
        for k,v in pairs(ents) do
            if v ~= inst and v.components.firefx and v.components.firefx.level then
                fireyness = fireyness + v.components.firefx.level
            end
        end

        return fireyness < 5
    end

    inst:AddComponent("heater")
    inst.components.heater.heatfn = GetHeatFn

    return inst
end

return Prefab("fire", fn, assets, prefabs)
